#ifndef _PEOPLE_H
#define _PEOPLE_H

#define WALK_FLAG 1

typedef struct {
	BYTE type;
	char speak[80];
	BYTE flag;
} PEOPLE;

PEOPLE *create_people ( BYTE type, char *speak );

BOOL can_walk ( PEOPLE *people );

void set_flag ( PEOPLE *people, BYTE flag );

void destroy_people ( PEOPLE *people );

/////////////////////////////

PEOPLE *create_people ( BYTE type, char *speak ) {
	PEOPLE *people;

	people = ( PEOPLE * ) malloc ( sizeof ( PEOPLE) );
	people->type = type;
	strcpy ( people->speak, speak );
	people->flag = 0;
	return people;
}

BOOL can_walk ( PEOPLE *people ) {
	return ( people->flag & WALK_FLAG );
}

void set_flag ( PEOPLE *people, BYTE flag ) {
	people->flag |= flag;
}

void destroy_people ( PEOPLE *people ) {
	free ( people );
}

#endif